<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Ultimate Media Gallery v1.4.3                                          # ||
|| #                                                                        # ||
|| # ---------------------------------------------------------------------- # ||
|| # Copyright  2008-2009 pHp-unlimited. All Rights Reserved.              # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| # It's not allowed to delete this Information.                           # ||
|| ########################################################################## ||
\*============================================================================*/

$onpage = true;
$show['customs'] = false;
$custom_fields = unserialize ($vbulletin->umg_custom);
foreach ($custom_fields as $key => $val)
{
	if ($key AND $val['active']) $show['customs'] = true;
}

$v_mediainfo = $vbulletin->options['umg_gallery_minfos'];
$r_position = $vbulletin->options['umg_gallery_rateposition'];
$e_position = $vbulletin->options['umg_gallery_ecardposition'];

$media = $db->query_first ("SELECT 
	media.*,user.username,COUNT(comment.comid) AS ccount,
	cat.userid AS gallery,cat.title AS cattitle,cat.description AS catdescription,cat.rateit,cat.comments,cat.modcomm,cat.permission,
	cat.buddies,cat.friends,cat.parentid 
	FROM " . TABLE_PREFIX . "umg_media AS media 
	LEFT JOIN " . TABLE_PREFIX . "umg_category AS cat ON (cat.catid=media.catid) 
	LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid=media.userid) 
	LEFT JOIN " . TABLE_PREFIX . "umg_comment AS comment ON (comment.mediaid=media.mediaid " . $comment_query . ") 
	WHERE media.mediaid=" . $vbulletin->GPC['m'] . "
	GROUP BY media.mediaid
");
if ($media['gallery'] == '' OR $media['gallery'] == NULL)
{
	print_no_permission ();
}

// this was the old hitcounter - now it counts over AJAX
if (!$vbulletin->GPC['nh'])
{
//	$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_media SET counter=counter+1 WHERE mediaid=" . $vbulletin->GPC['m']);
//	umg_create_datastore ('counter_' . (!$media['gallery'] ? 'public' : 'private'));
}

$next = $last = 0;
$medias = $db->query_read ("SELECT 
	media.*,COUNT(comment.comid) AS comcount 
	FROM " . TABLE_PREFIX . "umg_media AS media 
	LEFT JOIN " . TABLE_PREFIX . "umg_comment AS comment ON (comment.mediaid=media.mediaid AND comment.moderate=0) 
	WHERE catid=" . $media['catid'] . " 
	GROUP BY media.mediaid 
");
$mids = array ();
while ($m = $db->fetch_array ($medias))
{
	if ($m['active'])
	{
		if ($m['userid'] == $vbulletin->userinfo['userid'] OR $vbulletin->userinfo['deletemedia']) $mids[] = $m['mediaid'];
	}
	else $mids[] = $m['mediaid'];
}
$key = array_search ($media['mediaid'], $mids);
if ($mids[$key - 1] != 0) $last = $mids[$key - 1];
if ($mids[$key + 1] != 0) $next = $mids[$key + 1];

// check the permission first
if ($media['gallery'] AND !($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canseeprivate'])) print_no_permission ();
//if (!($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canseeprivate'])) print_no_permission ();

// let's see if we need a password (also in an upper category) or check for timeshift
$category_infos = $showcats = $category_list = $parent_list = $mother_categories = array ();
umg_get_categories ($category_list, $parent_list, $media['catid'], -1, $media['gallery']);
umg_get_mother_categories ($category_infos, $media['catid'], $mother_categories);

$show['linked'] = true;
$show['tags'] = $show['lm'] = $show['comments'] = $show['mrating'] = $show['rating'] = false;

$show['ratemedia'] = true;

$mcolspan = 1;
if ($media['rateit'] AND ($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canrateumg'])) $show['mrating'] = true;

$rate = $db->query_first ("SELECT vote FROM " . TABLE_PREFIX . "umg_rating WHERE mediaid=" . $media['mediaid'] . " AND userid=" . $vbulletin->userinfo['userid']);
if ($rate['vote']) $show['rating'] = true;

$rating = 0;
$media_rating = '&nbsp;';
if ($media['votenum'])
{
	$media['voteavg'] = vb_number_format ($media['votetotal'] / $media['votenum'], 2);
	$rating = round ($media['votetotal'] / $media['votenum']);

	$media_rating = "<img class=\"inlineimg\" src=\"$stylevar[imgdir_rating]/rating_$rating.gif\" alt=\"" . construct_phrase ($vbphrase['umg_rating_x_votes_y_average'], $media['votenum'], $media['voteavg']) . "\" border=\"0\" />";
}
else if ($show['rating'])
{
	$rating = $rate['vote'];
	$media_rating = "<img class=\"inlineimg\" src=\"$stylevar[imgdir_rating]/rating_$rating.gif\" alt=\"\" border=\"0\" />";
}

// show the medium
$comments = 0;
$isimage = 1;
$gallery = $media['category'];
$mediaid = $media['mediaid'];

// Owner of the media to delete it ?
$owner = 0;

// approved media
$bgclass = 'panel';
if ($media['active']) $bgclass = 'inlinemod';

if ($media['comments']) $show['comments'] = true;

if ($vbulletin->userinfo['deletemedia'] OR $vbulletin->userinfo['userid'] == $media['userid'])
{
	$owner = 1;
	$show['inlinetool'] = true;
}

$dateline = vbdate ($vbulletin->options['dateformat'], $media['dateline'], 1) . ' ' . vbdate ($vbulletin->options['timeformat'], $media['dateline']);

$albumimage = '<img src="umg_view.php?' . $session['sessionurl'] . 'do=m&amp;mediaid=' . $media['mediaid'] . '" border="0" />';
$original = 'umg_gallery/images/' . $media['gallery'] . '/original/' . $media['mediaid'] . '_' . $media['filename'];
$original_backup = 'umg_view.php?' . $session['sessionurl'] . 'do=o&amp;w=1&amp;mediaid=' . $media['mediaid'];

$media_types = $gallery_media_types;

if (in_array ($media['filetype'], $media_types))
{
	$isimage = 0;
	$media_url  = 'umg_gallery/images/0/original/' . $media['mediaid'] . '_' . $media['efilename'];

	$extension = $media['filetype'];
	include (DIR . '/umg_gallery/umg_extensions.php');

	if ($media_array['mtpl'] == 'html')
	{
		$HTML_Content = file_get_contents (DIR . '/umg_gallery/images/' . $media['gallery'] . '/original/' . $media['mediaid'] . '_' . $media['efilename']);
		if ($extension == 'txt')
		{
			$HTML_Content = str_replace (chr (13), '<br />', $HTML_Content);
		}
	}

	eval ('$album_image = "' . fetch_template ('umg_player_' . $media_array['mtpl']) . '";');
}
else if ($media['filetype'] == 'url')
{
	// we've got an URL
	$isimage = 0;
	$matches = null;
	$url_ok = false;
	$message = '[media]' . $media['efilename'] . '[/media]';

	if (!preg_match_all ('{\[url\](.+)\[\/url\]}i', $message, $matches) AND !preg_match_all ('{\[media\](.+)\[\/media\]}i', $message, $matches)) {}
	$find = $replace = array();

	require_once (DIR . '/includes/class_umgmedia.php');

	foreach ($matches[1] as $url)
	{
		$umgmedia = new umg_media ($vbulletin);
		if ($info = $umgmedia->parse_url ($url, array ('title')))
		{
			if (in_array ($info['profile'], array ('html', 'flash', 'falshvar', 'flashvarextra', 'divx', 'quick_time')))
			{
				$url_ok = true;
				break;
			}
		}
	}

	if ($url_ok)
	{
		$media_array = $info;
		$media_array['unique'] = $media['mediaid'];
		switch ($info['profile'])
		{
			case 'html':
				$mtpl = 'html';
				$HTML_Content = '';
				break;

			case 'flash':
				$mtpl = 'flash';
				break;

			case 'flashvar':
				$mtpl = 'flashvar';
				break;

			case 'flashvarextra':
				$mtpl = 'flashvarextra';
				break;

			case 'divx':
				$mtpl = 'divx';
				break;

			case 'quick_time':
				if ((!$media_array['width'] OR !$media_array['height']) AND $media_array['site'] == 'apple')
				{
					if (eregi ('640', $media_array['src']))						// 640 x 272
					{
						$media_array['width']  = 640;
						$media_array['height'] = 300;
					}
					else if (eregi ('480', $media_array['src']))			// 480 x 204
					{
						$media_array['width']  = 480;
						$media_array['height'] = 224;
					}
					else if (eregi ('320', $media_array['src']))			// 320 x 136
					{
						$media_array['width']  = 320;
						$media_array['height'] = 166;
					}
				}

				$mtpl = 'quicktime';
				break;
		}
		eval ('$album_image = "' . fetch_template ('umg_player_' . $mtpl) . '";');
	}
	else
	{
		eval ('$album_image = "' . fetch_template ('umg_player_none') . '";');
	}
}
else
{
	$media_array = array (
		'mid' => $media['mediaid'],
		'src' => $original
	);

	if ($vbulletin->options['umghs_active'])
	{
		$media_array['src'] = $original_backup;

		$key = $vbulletin->options['umghs_outline'];
		$outline_array = array ('', 'beveled', 'outer-glow', 'drop-shadow', 'rounded-white', 'rounded-black', 'glossy-dark');
		$highslide_outline = $outline_array["$key"];
		eval ('$album_image = "' . fetch_template ('umg_player_image') . '";');
	}
	else
	{
		$popsize_w = $vbulletin->options['umghs_popupw'];
		$popsize_h = $vbulletin->options['umghs_popuph'];
		$albumimage = '<a href="javascript:openImage(' . $media['mediaid'] . ',' . $popsize_w . ',' . $popsize_h . ')">' . $albumimage . '</a>';
		eval ('$album_image = "' . fetch_template ('umg_player_none') . '";');

		// update hitcounter (there is no ajax)
		$db->query_write ("UPDATE " . TABLE_PREFIX . "umg_media SET counter=counter+1 WHERE mediaid=" . $media['mediaid']);
		umg_create_datastore ('counter_' . (!$media['gallery'] ? 'public' : 'private'));
		$media['counter'] = $media['counter'] + 1;
	}
}

// ecard
$show['extra'] = false;

$media_dimensions = '&nbsp;';
if ($isimage) $isize = @getimagesize ($original);
if ($isimage AND ($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canuseecard']))
{
	if ($isize[0] >= $vbulletin->options['umge_width'] AND $isize[1] >= $vbulletin->options['umge_height'])
	{
		$show['extra'] = true;
		$media_dimensions = $isize[0] . ' x ' . $isize[1];
	}
	else
	{
		$media_dimensions = $isize[0] . ' x ' . $isize[1];
	}
}
else if ($isimage)
{
	$media_dimensions = $isize[0] . ' x ' . $isize[1];
}
$media_size = umg_set_filesize ($media['filesize']);
$media_date = vbdate ($vbulletin->options['dateformat'], $media['dateline'], 1) . ' ' . vbdate ($vbulletin->options['timeformat'], $media['dateline']);

if ($show['mrating'] AND $show['extra']) $mcolspan = ' colspan="3"';
else if ($show['mrating'] OR $show['extra']) $mcolspan = ' colspan="2"';

// get EXIF informations
$inf_create = false;
if ($media['exif'])
{
	$exif_title = 'EXIF';
	$extension = $media['filetype'];
	$filename = $original;
	include_once (DIR . '/umg_gallery/umg_exif.php');

	$row = 0;
	$tr = false;
	if (count ($image_exif_data))
	{
		$inf_create = true;
		$inf_array = $image_exif_data;
	}
	else $media['exif'] = false;
}
else if ($media['filetype'] == 'mp3')
{
	$exif_title = 'ID3 Tag';
	require_once (DIR . '/includes/class_umgid3v1x.php');
	require_once (DIR . '/includes/class_umgid3v2.php');

	$id3_results = array ();
	$id3tag = new ID3 (DIR . '/umg_gallery/images/' . $gallery . '/original/' . $media['mediaid'] . '_' . $media['efilename']);

	$tags = $id3tag->getInfo();
	if (count ($tags))
	{
		$find_array = array ('TPE1',   'TIT2',  'TALB',  'TYER', 'TCON',   'TCOM',     'TPUB',      'TCOP',      'USLT');
		$tag_array  = array ($vbphrase['umg_artist'], $vbphrase['umg_ttitle'], $vbphrase['umg_album'], $vbphrase['umg_year'], $vbphrase['umg_genre'], $vbphrase['umg_composer'], $vbphrase['umg_publisher'], $vbphrase['umg_copyright'], $vbphrase['umg_lyric']);
		if (!empty ($tags))
		{
			foreach ($tags AS $tag => $value)
			{
				$key = array_search ($tag, $find_array);
				if (is_numeric ($key))
				{
					$id3_results[$tag_array["$key"]] = $value;
				}
			}
		}
	}
	else
	{
		// try ID3 Tag v1.0
		$id3tag = new ID3v1x (DIR . '/umg_gallery/images/' . $gallery . '/original/' . $media['mediaid'] . '_' . $media['efilename']);
		$item = strtolower ('title');
		$id3tag->read_tag();
		if ($id3tag->tag != 'noid3v1.x' AND $id3tag->$item != '') $id3_results[] = $id3tag->$item;
	}

	if (count ($id3_results))
	{
		$row = 0;
		$tr = false;
		if (count ($id3_results))
		{
			$media['exif'] = $inf_create = true;
			$inf_array = $id3_results;
		}
	}
}
// create the Informations
if ($inf_create)
{
	$exif_informations = '';
	foreach ($inf_array AS $key => $val)
	{
		if (!$row)
		{
			if ($tr)
			{
				$tr = false;
				$exif_informations .= "</tr>\n";
			}
			if (!$tr)
			{
				$tr = true;
				$exif_informations .= "<tr>\n";
			}
		}
		$exif_informations .= "<td class=\"alt2\" style=\"width:25%\" align=\"" . $stylevar['right'] . "\"><span class=\"smallfont\">" . $key . ":</span></td>\n";
		$exif_informations .= "<td class=\"alt2\" style=\"width:25%\"  align=\"" . $stylevar['left'] . "\"><span class=\"smallfont\">" . $val . "</span></td>\n";
		$row++;
		if ($row == 2) $row = 0;
	}
	if ($row == 1) $exif_informations .= "<td class=\"alt2\" style=\"width:25%\" colspan=\"2\">&nbsp;</td>\n";
	if ($tr) $exif_informations .= "</tr>\n";
}


if ($media['filetype'] == 'url')
{
	$show['linked'] = false;
}
else
{
	$show['img_tag'] = true;
	$fname = $media['filename'];
	if ($fname != $media['efilename'] AND $media['efilename'] != '')
	{
		// we have no image !
		$show['img_tag'] = false;
		$fname = $media['efilename'];
		$link_medium = '[URL=' . $vbulletin->options['bburl'] . '/umg_view.php?' . $session['sessionurl'] . 'do=m&amp;mediaid=' . $media['mediaid'] . '][IMG]' . $vbulletin->options['bburl'] . '/umg_view.php?' . $session['sessionurl'] . 'do=m&amp;mediaid=' . $media['mediaid'] . '[/IMG][/URL]';
	}
	else
	{
		$link_medium = '[URL=' . $vbulletin->options['bburl'] . '/umg_view.php?' . $session['sessionurl'] . 'do=m&amp;mediaid=' . $media['mediaid'] . '][IMG]' . $vbulletin->options['bburl'] . '/umg_view.php?' . $session['sessionurl'] . 'do=m&amp;mediaid=' . $media['mediaid'] . '[/IMG][/URL]';
	}

	$small  = '[IMG]' . $vbulletin->options['bburl'] . '/umg_view.php?' . $session['sessionurl'] . 'do=s&amp;mediaid=' . $media['mediaid'] . '[/IMG]';
	$medium = '[IMG]' . $vbulletin->options['bburl'] . '/umg_view.php?' . $session['sessionurl'] . 'do=m&amp;mediaid=' . $media['mediaid'] . '[/IMG]';
}

require_once (DIR . '/includes/class_bbcode.php');

// parse description
if ($media['description'])
{
	$bbcode_parser =& new vB_BbCodeParser ($vbulletin, fetch_tag_list ());
	// message, html, smilies, bbcodes, images
	$description = stripslashes ($bbcode_parser->do_parse ($media['description'], $umg_html_allowed, $umg_smilie_allowed, $umg_bbcode_allowed, $umg_images_allowed));
}
else
{
	$description = '&nbsp;';
}

// this is the comment part
$commentbits = '';
$show['commallowed'] = true;				// comments are avaible

$show['mcom'] = false;
if ($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canmakecomments']) $show['mcom'] = true;


if (!$media['ccount'])
{
	eval ('$commentbits = "' . fetch_template ('umg_comment_empty') . '";');
}
else
{

	$limit = $vbulletin->options['umg_com_numbers'];
	if ($vbulletin->GPC['pagenumber'] < 1) $vbulletin->GPC['pagenumber'] = 1;
	$total_pages = $media['ccount'];
	$pagenumber = ($vbulletin->GPC['pagenumber'] > $total_pages ? $total_pages : $vbulletin->GPC['pagenumber']);
	$start = ($pagenumber - 1) * $limit;
	if ($start < 0) $start = 0;
	if ($limit <= 0) $limit = 2;

	require_once (DIR . '/includes/functions_bigthree.php');
	require_once (DIR . '/includes/class_postbit.php');

	$comments = $db->query_read ("SELECT 
	media.mediaid AS mid,comment.*,
		spa.signatureparsed,spa.hasimages AS sighasimages, 
		sp.userid AS sigpic,sp.dateline AS sigpicdateline,sp.width AS sigpicwidth,sp.height AS sigpicheight,sp.filename AS sigpicfilename,sp.filedata AS sicpicfiledata, 
	cat.userid AS gallery,u.username,u.joindate,u.usertitle,u.usergroupid,u.membergroupids,i.iconpath 
	FROM " . TABLE_PREFIX . "umg_media AS media 
	LEFT JOIN " . TABLE_PREFIX . "umg_category AS cat ON (cat.catid=media.catid) 
	LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid=media.userid) 
	LEFT JOIN " . TABLE_PREFIX . "umg_comment AS comment ON (comment.mediaid=media.mediaid " . $comment_query . ") 
	LEFT JOIN " . TABLE_PREFIX . "sigparsed AS spa ON(spa.userid=u.userid AND spa.styleid = " . intval(STYLEID) . " AND spa.languageid = " . intval(LANGUAGEID) . ")
	LEFT JOIN " . TABLE_PREFIX . "sigpic AS sp ON(sp.userid=u.userid)
	LEFT JOIN " . TABLE_PREFIX . "icon AS i ON (i.iconid=comment.iconid) 
	WHERE media.mediaid=" . $vbulletin->GPC['m'] . "
	ORDER BY dateline ASC 
	LIMIT $start,$limit 
	");
	$show['inlinemod'] = false;
	$dellink = $modlink = 0;
	while ($comment = $db->fetch_array ($comments))
	{
		// settings from AdminCP
		$show['postcount'] = true;
		$show['signature'] = true;
		$show['doavatar']  = true;

		$show['join'] = $show['profile'] = true;
		$show['quickreply'] = true;

		$show['moderated'] = $comment['moderate'];
		$show['checkbox'] = $show['editlink'] = false;
		if (!$media['gallery'])
		{
			// public gallery
			if ($med OR $mdel) $show['editlink'] = $show['checkbox'] = $show['inlinemod'] = $modlink = $dellink = true;
			else
			{
				if ($vbulletin->userinfo['userid'] == $comment['userid'] AND ($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['caneditcomments'])) $show['checkbox'] = $show['editlink'] = true;
				if ($vbulletin->userinfo['userid'] == $comment['userid'] AND $permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['candeletecomments']) $show['checkbox'] = $show['inlinemod'] = $dellink = true;
			}
		}
		else
		{
			// private gallery
			if ($med OR $mdel) $show['editlink'] = $show['inlinemod'] = $show['checkbox'] = $modlink = $dellink = true;
			if ($comment['gallery'] == $vbulletin->userinfo['userid'] AND $permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['canmodcomments'])
			{
				$dellink = $modlink = $show['editlink'] = $show['checkbox'] = $show['inlinemod'] = true;
			}
			else
			{
				if ($vbulletin->userinfo['userid'] == $comment['userid'] AND ($permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['caneditcomments'])) $show['checkbox'] = $show['editlink'] = true;
				if ($vbulletin->userinfo['userid'] == $comment['userid'] AND $permissions['umgpermissions'] & $vbulletin->bf_ugp_umgpermissions['candeletecomments']) $show['checkbox'] = $dellink = true;
				if ($dellink) $show['inlinemod'] = true;
			}
		}

		$user = fetch_userinfo ($comment['userid']);
		$pe = cache_permissions ($user);

		$comid = $comment['comid'];
		$commentcount++;
		$show['gallery'] = false;
		if (!$user['username'])
		{
			$show['join'] = $show['profile'] = false;
			$user['musername'] = '<b>' . $vbphrase['umg_unregistered'] . '</b>';
		}
		else
		{
			$userstat= unserialize ($vbulletin->umg_statistics);
			if (in_array ($vbulletin->userinfo['userid'], $userstat['private_users'])) $show['gallery'] = true;
		}

		$avwidth = '';
		$avheight = '';
		$avatarurl = '';
		if ($user['avatarid'] AND $show['doavatar'])
		{
			$avatarurl = $user['avatarpath'];
		}
		else if ($show['doavatar'])
		{
			if ($user['hascustomavatar'] AND $vbulletin->options['avatarenabled'] AND ($pe['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canuseavatar'] OR $user['adminavatar']))
			{
				if ($vbulletin->options['usefileavatar'])
				{
					$avatarurl = $vbulletin->options['avatarurl'] . "/avatar" . $vbulletin->userinfo['userid'] . "_" . $vbulletin->userinfo['avatarrevision'] . ".gif";
				}
				else
				{
					$avatarurl = 'image.php?' . $session['sessionurl'] . "u=" . $vbulletin->userinfo['userid'] . "&amp;dateline=" . $vbulletin->userinfo['avatardateline'];
				}
				if ($userinfo['avheight'] AND $userinfo['avwidth'])
				{
					$avheight = "height=\"$user[avheight]\"";
					$avwidth = "width=\"$user[avwidth]\"";
				}
			}
			else $avatarurl = '';
		}

		if ($avatarurl == '') $show['avatar'] = false;
		else $show['avatar'] = true;

		// message, html, smilies, bbcodes, images
		$bbcode_parser =& new vB_BbCodeParser ($vbulletin, fetch_tag_list ());
		$comment['comment'] = stripslashes ($bbcode_parser->do_parse ($comment['comment'], $umg_html_allowed, $umg_smilie_allowed, $umg_bbcode_allowed, $umg_images_allowed));
//		if ($show['signature'] AND $user['signature']) $user['signature'] = stripslashes ($bbcode_parser->do_parse ($user['signature'], 0, 1, 1, 1));
		if ($show['signature'] AND $user['signature'])
		{
			require_once (DIR . '/includes/class_sigparser.php');
			$sig_parser =& new vB_SignatureParser ($vbulletin, fetch_tag_list (), $user['permissions'], $user['userid']);
			$signature = $user['signature'];
			if ($comment['sigpic'])
			{
				if ($comment['sigpicfiledata'] != '')
				{
					$sigpicurl = 'image.php?' . $vbulletin->session->vars['sessionurl'] . 'type=sigpic&amp;userid=' . $user['userid'] . "&amp;dateline=" . $comment['sicpicdateline'];
				}
				else
				{
					$sigpicurl = $vbulletin->options['sigpicpath'] . '/sigpic' . $user['userid'] . '_' . $user['sigpicrevision'] . '.gif';
				}
			}
			$bbcode_parser =& new vB_BbCodeParser ($vbulletin, fetch_tag_list ());
			$bbcode_parser->set_parse_userinfo (fetch_userinfo($user['userid'], FETCH_USERINFO_SIGPIC), $user['permissions']);
			$user['signature'] = $bbcode_parser->parse ($signature, 'signature');
		}

		$user['joindate'] = vbdate ($vbulletin->options['dateformat'], $user['joindate'], false);
		$comment['date'] = vbdate ($vbulletin->options['dateformat'], $comment['dateline'], 1) . ' ' . vbdate ($vbulletin->options['timeformat'], $comment['dateline']);

		fetch_online_status ($user, true);
		construct_im_icons ($user);

		if (!$vbulletin->options['legacypostbit']) eval ('$commentbits .= "' . fetch_template ('umg_comment') . '";');
		else
		{
			$colspan = ' colspan="2"';
			eval ('$commentbits .= "' . fetch_template ('umg_comment_legacy') . '";');
		}
	}
	$show['dellink'] = $dellink;
	$show['modlink'] = $modlink;

	$pagenav = construct_page_nav ($pagenumber, $limit, $total_pages, 'umg.php?' . $vbulletin->session->vars['sessionurl'] . "m=" . $media['mediaid'], ""
		. (!empty ($vbulletin->GPC['perpage']) ? "&amp;pp=$perpage" : '')
	);
}

// mediatags
$tags = array ();
$medtags = $db->query_read ("SELECT 
	tm.*, t.tagtext 
	FROM " . TABLE_PREFIX . "umg_tagmedia AS tm 
	LEFT JOIN " . TABLE_PREFIX . "umg_tag AS t ON (t.tagid=tm.tagid) 
	WHERE tm.mediaid=" . $media['mediaid'] . "
");
while ($mtags = $db->fetch_array ($medtags))
{
	$show['tags'] = true;
	$tags[] = '<a href="umg.php?' . $session['sessionurl'] . 'do=search&amp;tags=' . $mtags['tagtext'] . '">' . $mtags['tagtext'] . '</a>';
}
$media_tags = implode (', ', $tags);

// custom fields
if ($show['customs'])
{
	$fields = $db->query_read ("SELECT 
		cf.value,c.* 
		FROM " . TABLE_PREFIX . "umg_customfield AS cf 
		LEFT JOIN " . TABLE_PREFIX . "umg_custom AS c ON (c.id=cf.customid) 
		WHERE mediaid=" . $mediaid
	);
	while ($field = $db->fetch_array ($fields))
	{
		$id = $field['id'];
		$cfields["$id"] = $field;
	}
	if (!empty ($cfields))
	{
		$x = 0;
		$custom_bit = '';
		foreach ($cfields as $key => $value)
		{
			$field_value = '';
			if ($value['fieldtype'] == 1)
			{
				$field_value = $value['value'];
			}
			else if ($value['fieldtype'] == 2)
			{
				if (!function_exists('vB_BbCodeParser'))
				{
					require_once (DIR . '/includes/class_bbcode.php');
					$bbcode_parser =& new vB_BbCodeParser ($vbulletin, fetch_tag_list ());
				}
				// message, html, smilies, bbcodes, images
				$field_value = stripslashes ($bbcode_parser->do_parse ($value['value'], $umg_html_allowed, $umg_smilie_allowed, $umg_bbcode_allowed, $umg_images_allowed));
			}
			else if ($value['fieldtype'] == 3)
			{
				$options = explode (chr (13), $value['default']);
				$max = $val['length'];
				if (!$val['length']) $max = count ($options);

				$y = 0;
				foreach ($options as $opt => $title)
				{
					$po = $opt + 1;
					if ($y == $max)
					{
						$y = 0;
						$field_value .= '<br />';
					}
					if (trim ($title) != '')
					{
						$y++;
						$selected = '';
						if ($po == $value['value']) $selected = 'checked="checked" ';
						$field_value .=  "<input type=\"radio\" name=\"field\" value=\"1\" " . $selected . "/>" . trim ($title) . "&nbsp;";
					}
				}
			}
			else if ($value['fieldtype'] == 4)
			{
				$boxes = 0;
				$options = explode (chr (13), $value['default']);
				$mvals = explode ('|||', $value['value']);
				$max = count ($options);
				if ($value['length']) $max = $value['length'];
				$y = 0;
				foreach ($options as $opt => $title)
				{
					$po = $opt + 1;
					$selected = '';
					if (count ($mvals))
					{
						foreach ($mvals as $m => $v)
						{
							if ($po == $v) $selected = 'checked="checked" ';
						}
					}
					if ($y == $max)
					{
						$y = 0;
						$field_value .= '<br />';
					}
					if (trim ($title) != '')
					{
						$field_value .= "<input type=\"checkbox\" name=\"field[]\" value=\"1\" " . $selected . "/>" . trim ($title) . "&nbsp;";
						$y++;
					}
				}
			}
			else if ($value['fieldtype'] == 5)
			{
				$size = $val['length'];
				$options = explode (chr (13), $value['default']);
				if (count ($options) < $size) $size = count ($options);

				$field_value .= "<select name=\"field\" size=\"" . $size . "\">\n";
				foreach ($options as $opt => $title)
				{
					$po = $opt + 1;
					$selected = '';
					if ($po == $value['value']) $selected = 'selected="selected"';
					if (trim ($title)) $field_value .= "<option value=\"" . $po . "\" " . $selected . ">" . trim ($title) . "</option>\n";
				}
				$field_value .= "</select>";
			}
			else if ($value['fieldtype'] == 6)
			{
				$size = $value['length'];
				$options = explode (chr (13), $value['default']);
				if (count ($options) < $size) $size = count ($options);
				$mvals = explode ('|||', $value['value']);

				$field_value .= "<select multiple=\"multiple\" name=\"field_" . $val['id'] . "[]\" size=\"" . $size . "\">\n";
				foreach ($options as $opt => $title)
				{
					$po = $opt + 1;
					$selected = '';
					if (count ($mvals))
					{
						foreach ($mvals as $m => $v)
						{
							if ($po == $v) $selected = ' selected="selected"';
						}
					}
					if (trim ($title)) $field_value .= "<option value=\"" . $opt . "\"" . $selected . ">" . trim ($title) . "</option>\n";
				}
				$field_value .= "</select>";
			}


			if (!$x) $custom_bit .= "<tr valign=\"top\">\n";
			$custom_bit .= "<td class=\"alt2\" align=\"" . $stylevar['right'] . "\" style=\"width:25%\"><span class=\"smallfont\">" . $value['title'] . ":</span></td>\n";
			$custom_bit .= "<td class=\"alt2\" align=\"" . $stylevar['left'] . "\" style=\"width:25%\"><span class=\"smallfont\">" . $field_value . "</span></td>\n";
			$x++;
			if ($x == 2)
			{
				$x = 0;
				$custom_bit .= "</tr>\n";
			}
		}
		if ($x) $custom_bit .= "<td class=\"alt2\" align=\"" . $stylevar['right'] . "\" style=\"width:50%\" colspan=\"2\">&nbsp;</td></tr>\n";
	}
	else
	{
		$show['customs'] = false;
	}
}


// quickreply
if ($vbulletin->options['umg_com_quick'] AND $media['modcomm'] AND !is_browser ('netscape') AND $vbulletin->userinfo['userid']) $show['quickreply'] = true;
else
{
	$show['quickreply'] = false;
	$show['wysiwyg'] = 0;
	$quickreply = '';
}
if ($show['quickreply'])
{
	require_once(DIR . '/includes/functions_editor.php');

	$show['wysiwyg'] = ($forum['allowbbcode'] ? is_wysiwyg_compatible() : 0);
	$istyles_js = construct_editor_styles_js();

	// set show signature hidden field
	$showsig = iif($vbulletin->userinfo['signature'], 1, 0);

	$qrpostid = $media['mediaid'];
	$show['qr_require_click'] = 0;

	$editorid = construct_edit_toolbar('', 0, $foruminfo['forumid'], ($foruminfo['allowsmilies'] ? 1 : 0), 1, false, 'qr');
	$messagearea = "
		<script type=\"text/javascript\">
		<!--
			var threaded_mode = 1;
			var require_click = 0;
			var is_last_page = 0;
			var allow_ajax_qr = 0;
			var ajax_last_post = 0;
		// -->
		</script>
		$messagearea
	";

	if (is_browser('mozilla') AND $show['wysiwyg'] == 2)
	{
		$show['quickreply_collapse'] = false;
		unset(
			$vbcollapse["collapseobj_quickreply"],
			$vbcollapse["collapseimg_quickreply"],
			$vbcollapse["collapsecel_quickreply"]
		);
	}
	else
	{
		$show['quickreply_collapse'] = true;
	}

}

$media_w = $media_h = 0;
if ($media['width'])  $media_w = $media['width'];
if ($media['height']) $media_h = $media['height'];

if (!$vbulletin->options['umg_start_exif'] AND !$vbulletin->userinfo['userid']) $media['exif'] = false;
if (!$vbulletin->options['umg_start_links'] AND !$vbulletin->userinfo['userid']) $show['linked'] = false;

if ($media['exif'] OR $show['linked']) $show['lm'] = true;
$media_category = '<a href="umg.php?' . $session['sessionurl'] . 'c=' . $media['catid'] . '">' . $media['cattitle'] . '</a>';
eval ('$gallery_public = "' . fetch_template ('umg_show_media') . '";');

// create the navigation
array_pop ($gallery_navbits);
if ($gallery)
{
	$link = 'umg.php?' . $session['sessionurl'] . 'u=' . $media['userid'];
	$gallery_navbits[$link] = $media['username'] . $vbphrase['umg_x_his_gallery'];
}
sort ($mother_categories);
foreach ($mother_categories as $mc => $mid)
{
	$title = $category_infos[$mid]['title'];
	$link = 'umg.php?' . $session['sessionurl'] . 'c=' . $mid;
	$gallery_navbits[$link] = $category_infos[$mid]['title'];
}
$gallery_navbits[] = $media['title'];
?>
